* MONINetl.sps Carga de Datos MONIN 2010-Feb-14 Viper@upch.edu.pe 2010-Dic-21.
* Entrada (CSV generados por MONINetl.vbs): P.csv, T.csv, M.csv, N.csv.
* SPSS V7.5 solo lee DBF, pero export de XLS a DBF pierde decimales, V15 lee CSV.
* Salida.
* T.sav	Tabla de Conglomerados.
* P.sav	Tabla de Nios.
* M.sav	Tabla de Mujeres.
* SET UNDEFINED= WARN.
* Rutas de Trabajo (modificar con la ubicacin de la entrada y salida).
FILE HANDLE TBCSV /NAME='X:\T.csv' .
FILE HANDLE PBCSV /NAME='X:\P.csv' .
FILE HANDLE MBCSV /NAME='X:\M.csv' .
FILE HANDLE NBCSV /NAME='X:\N.csv' .
FILE HANDLE TBDBF /NAME='X:\T.dbf' .
FILE HANDLE TBSAV /NAME='X:\T.SAV' .
FILE HANDLE PBDBF /NAME='X:\P.dbf' .
FILE HANDLE PBSAV /NAME='X:\P.SAV' .
FILE HANDLE MBDBF /NAME='X:\M.dbf' .
FILE HANDLE MBSAV /NAME='X:\M.SAV' .
FILE HANDLE NBSAV /NAME='X:\N.SAV' .
* Tabla de Conglomerados .
* GET TRANSLATE FILE=TBDBF /TYPE=DBF /MAP .
GET DATA  /TYPE=TXT /FILE=TBCSV
 /DELCASE=LINE /DELIMITERS= "," /QUALIFIER='"'
 /ARRANGEMENT=DELIMITED /FIRSTCASE=2 /IMPORTCASE=ALL
 /VARIABLES=
 Amb A3
 Cong A4
 Equipo F2.0
 Periodo F1.0
 Salida F2.0
 TotVivE F3.0
 TotVivO F3.0
 NVivsL F3.0
 NVivsLE F3.0
 NClasV F3.0
 NuHog F3.0
 NEleDes F3.0
 NNoEle F3.0
 NEleNo F3.0
 NEleRe F2.0
 NCoEViv F3.0
 NVisInf F3.0
 NEleNo3v F3.0
 TotVivR F3.0
 TotVivA F3.0
 PlaImp F1.0
 P1C F20.10
 FLAT F14.10
 FLON F14.10
 FALT F4.0
 VertOc F1.0
 CCDD A2
 CCPP A2
 CCDI A2
 CCCP A4
 QUINTF F1.0
 QMEF F1.0
 CodETZ F2.0
 EtapaC F1.0
 NVivs F3.0
 NHabs F4.0
 CampoD F10.2
 NomDD A50
 NomPR A50
 NomDI A50
 NomCP A50
 MONIN5 F1.0
 StatusM F2.0
 DM2E F2.0
 P1R F20.10
 P2R F20.10
 P1N F10.2
 P1M F10.2
 P2F F9.2
 SWt F8.2
 AreaUR F1.0
 INEIE8 F1.0
 Estrato F1.0
 RegNat F1.0
 AER F1.0
 NNi04 F3.0
 NMEF F3.0
 NGes F3.0
 NNi02 F3.0
 N04HA F3.0
 N04HB F3.0
 N04CO F3.0
 Viv0 A4
 FIniCong DATETIME23.2
 FFinCong DATETIME23.2
 VFinCong A4
 FIni DATETIME23.2
 .
* CACHE.
EXECUTE.
VARIABLE LEVEL
 TotVivE TotVivO NVivsL NVivsLE NClasV NuHog 
 NEleDes NNoEle NEleNo NEleRe NCoEViv NVisInf NEleNo3v TotVivR TotVivA 
 NVivs NHabs NNi04 NMEF NGes NNi02 N04HA N04HB N04CO
 P1C P1R P2R SWt FLAT FLON FALT (SCALE)
 .
* DATASET NAME T WINDOW=FRONT.
COMPUTE DPTOPS2 = 0 .
IF ( ccdd = '01' ) DPTOPS2 = 1 .
IF ( ccdd = '06' ) DPTOPS2 = 1 .
IF ( ccdd = '25' ) DPTOPS2 = 1 .
IF ( ccdd = '03' ) DPTOPS2 = 1 .
IF ( ccdd = '09' ) DPTOPS2 = 1 .
IF ( ccdd = '10' ) DPTOPS2 = 1 .
IF ( ccdd = '05' ) DPTOPS2 = 1 .
IF ( ccdd = '08' ) DPTOPS2 = 1 .
IF ( ccdd = '21' ) DPTOPS2 = 1 .
COMPUTE P1R = P1R * (1.0E-9) .
COMPUTE P2R = P2R * (1.0E-6) .
RECODE P2R ( 1 THRU HI = 1 ) .
FORMAT P1R P2R ( F12.9 ) .
COMPUTE SWtC = 1 / P1R .
EXECUTE.
VARIABLE LABELS
	Amb	'Cdigo de mbito'
	Cong	'Cdigo de Conglomerado'
	Equipo	'Equipo'
	Periodo	'Periodo'
	Salida	'Salida'
	TotVivE	'Hogares entrevistados'
	TotVivO	'Hogares en plano'
	NVivsL	'Viviendas en marco local'
	NVivsLE	'Hogares enumerados'
	NClasV	'Viviendas clasificadas'
	NuHog	'Viviendas visitadas'
	NEleDes	'Viviendas desconocidas'
	NNoEle	'Hogares no elegibles'
	NEleNo	'Hogares elegibles no efectuados'
	NEleRe	'Hogares elegibles que rechazan'
	NCoEViv	'Hogares entrevistados'
	NVisInf	'Visitas efectuadas'
	NEleNo3v	'Elegibles sin 3 visitas'
	TotVivR	'IGNORAR'
	TotVivA	'IGNORAR'
	PlaImp	'Planos INEI vs Campo'
	P1C	'Conglos.P1'
	FLAT	'Latitud WGS84'
	FLON	'Longitud WGS84'
	FALT	'Altitud (m)'
	VertOc	'Vertiente'
	CCDD	'UbiGeo Departamento'
	CCPP	'UbiGeo Provincia'
	CCDI	'UbiGeo Distrito'
	CCCP	'INEI CCCP'
	QUINTF	'Quintil FonCoDes 2005'
	QMEF	'Quintil MEF 2001'
	CodETZ	'Cdigo Zonal PRONAA'
	EtapaC	'Etapa Crecer'
	NVivs	'Viviendas en Marco INEI'
	NHabs	'Habitantes en Marco INEI'
	CampoD	'IGNORAR'
	NomDD	'Departamento'
	NomPR	'Provincia'
	NomDI	'Distrito'
	NomCP	'Centro Poblado'
	MONIN5	'Estrato MONIN'
	StatusM	'Situacin Final'
	DM2E	'Muestreo 2da. Etapa'
	P1R	'P1 Conglomerado'
	P2R	'P2 Hogar'
	P1N	'IGNORAR'
	P1M	'IGNORAR'
	P2F	'IGNORAR'
	SWt	'IGNORAR'
	SWtC	'Ponderacin de Conglomerado'
	AreaUR	'rea UR'
	INEIE8	'Estrato Demogrfico'
	Estrato	'Estrato Original'
	RegNat	'Regin Natural'
	AER	'rea de Empadronamiento Rural'
	NNi04	'Nios 0-4 aos'
	NMEF	'Mujeres 15-49 aos'
	NGes	'Gestantes'
	NNi02	'Nios 0-2 aos'
	N04HA	'Nios 0-4 c/antropometra'
	N04HB	'Nios 0-4 c/hemoglobina'
	N04CO	'Nios 0-4 con consumo'
	Viv0	'Vivienda de arranque'
	FIniCong	'Inicio del conglomerado'
	FFinCong	'Fin del conglomerado'
	VFinCong	'Fin del conglomerado'
	DPTOPS2 'Regin PARSALUD II'
.
VALUE LABELS
	/ Periodo
		1 '2008-I'
		2 '2008-III'
		3 '2008-IV'
		4 '2009-II'
		5 '2009-III'
		6 '2009-IV'
		7 '2010-I'
	/ StatusM
		11 'terminados'
		12 'pendientes'
		13 'salen por reemplazo'
		14 'entran por reemplazo'
		15 'perdidos'
		16 'sorteo no documentado'
		17 'no intentaron, por referencia'
		18 'marco local incompleto'
		19 'solo cp mapeados'
		20 'excluido, dificultad logstica'
		21 'rea no corresponde'
		22 'tiempo no corresponde'
		23 'cobertura incompleta'
		29 'fuera de muestra'
		31 'faltan documentos'
		80 'no usado'
		99 'prueba/piloto/descarte'
	/ DM2E
		0 'Cuota (Periodo P1)'
		1 'Censo total y MAS'
		2 '1 Subunidad local (P1)'
		3 '4 CPs S/R (Periodo 2)'
		4 '1 CP & SC Cuanto'
		5 '1 CP & SC CENAN'
		6 '4 SCs C/R'
		7 '4 CPs C/R'
		9 'No determinado'
	/ PlaImp
		1 'igual'
		2 'similar'
		3 'diferente'
	/ VertOc
		1 'Pacfico'
		2 'Atlntico'
	/ MONIN5 Estrato
		1 'Lima Metropolitana'
		2 'Resto de Costa'
		3 'Sierra Urbana'
		4 'Sierra Rural'
		5 'Selva'
	/ AreaUR
		1 'Urbano'
		2 'Rural'
	/ INEIE8
		1 '>100k viviendas'
		2 '>20k a 100k viviendas'
		3 '>10k a 20k viviendas'
		4 '>4k a 10k viviendas'
		5 '401 a 4000 viviendas'
		6 '100-401 viviendas'
		7 'AER compuesta (dispersa)'
		8 'AER simple'
	/ RegNat
		1 'Costa'
		2 'Sierra'
		3 'Selva'
	/ AER
		1 'si AER'
		2 'no AER'
	/ DPTOPS2 0 'no' 1 'si' 
	/ EtapaC
		0 'No'
		1 'C1'
		2 'C2'
		3 'C3'
		4 'C4'
	/ QMEF QUINTF
		1 'Q1'
		2 'Q2'
		3 'Q3'
		4 'Q4'
		5 'Q5'
.
SORT CASES BY amb cong .
SAVE /OUTFILE TBSAV /COMPRESSED .
* Tabla de Nutrientes .
GET DATA  /TYPE = TXT /FILE = NBCSV
 /DELCASE = LINE /DELIMITERS = "," /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED /FIRSTCASE = 2 /IMPORTCASE = ALL
 /VARIABLES =
 Amb A3
 Cong A4
 Viv A4
 Hog A1
 IdM A2
 PESO F6.2
 ENERC F6.2
 PROTG F5.2
 PROTAG F5.2
 GRASG F5.2
 CARTG F5.2
 FIBDG F4.2
 HIERM F4.2
 RETIU F6.2
 ZINCMG F6.2
 PESOF F6.2
 ENERCF F6.2
 PROTGF F5.2
 GRASGF F5.2
 HIERMF F4.2
 RETIUF F6.2
 NRECS F3.0
 .
EXECUTE.
VARIABLE LEVEL PESO TO NRECS (SCALE) .
* RECODE PESO PESOF ( 5000 THRU HI = SYSMIS ) .
* RECODE ENERC ENERCF ( 3000 THRU HI = SYSMIS ) .
COMPUTE GCONS = PESO .
COMPUTE GCONSF = PESOF .
VARIABLE LABELS
	Amb	'Cdigo de mbito'
	Cong	'Cdigo de Conglomerado'
	Viv	'Cdigo de Vivienda'
	Hog	'Cdigo de Hogar'
	IdM	'Cdigo de Nio'
	GCONS	'Peso Consumido (g/d)'
	ENERC	'Energa (KCal/d)'
	PROTG	'Proteinas (g/d)'
	PROTAG	'Proteinas Animales (g/d)'
	GRASG	'Grasa (g/d)'
	CARTG	'Carbohidratos (g/d)'
	FIBDG	'Fibra Dietaria (g/d)'
	HIERM	'Hierro (mg/d)'
	RETIU	'Retinol (ug/d)'
	ZINCMG	'Zinc (mg/d)'
	GCONSF	'Peso Consumido s/LM (g/d)'
	ENERCF	'Energa s/LM (KCal/d)'
	PROTGF	'Proteinas s/LM (g/d)'
	GRASGF	'Grasa s/LM (g/d)'
	HIERMF	'Hierro s/LM (mg/d)'
	RETIUF	'Retinol s/LM (ug/d)'
	NRECS 'Filas de Consumo' 
.
.
SORT CASES BY amb cong viv hog idm .
SAVE /OUTFILE NBSAV /COMPRESSED .
* Tabla de Nios .
* GET TRANSLATE FILE=PBDBF /TYPE=DBF /MAP .
GET DATA  /TYPE = TXT /FILE = PBCSV
 /DELCASE = LINE /DELIMITERS = "," /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED /FIRSTCASE = 2 /IMPORTCASE = ALL
 /VARIABLES =
 Amb A3
 Cong A4
 Viv A4
 Hog A1
 IdM A2
 Estrato F1.0
 Cong1 F6.2
 Cong2 F7.2
 TResiM F5.2
 Sexo F1.0
 Met F1.0
 PesoKg F5.2
 TallaCm F6.2
 PNacG F7.2
 ZHAZ F15.7
 ZWHZ F15.7
 HFAZ F15.7
 WFHZ F15.7
 IMC F10.5
 HbCORR F10.5
 Retinol F5.2
 MaOK F1.0
 MaPte F1.0
 MaEdA F2.0
 MaEdu F1.0
 HV109 F1.0
 ConLM F1.0
 ConAL F1.0
 AliOK F1.0
 VComio F2.0
 MasGra F1.0
 VitA F1.0
 VFe F1.0
 SupOK F1.0
 PrAOK F1.0
 PDia2w F1.0
 PTos2w F1.0
 PFie2w F1.0
 NED7 F1.0
 NER7 F1.0
 NEDY F1.0
 NERY F1.0
 DenomP F1.0
 DenomID F1.0
 DenomIR F1.0
 DenomRD F1.0
 DenomRR F1.0
 NumeID F1.0
 NumeIR F1.0
 NumeRD F1.0
 NumeRR F1.0
 NVBCG F1.0
 NVPOL F1.0
 NVDPT F1.0
 NVHEP F1.0
 NVHIB F1.0
 NVSAR F1.0
 NVPaR F1.0
 NVAMA F1.0
 NVVTA F1.0
 NCCD0 F2.0
 ECCD0 F6.2
 NMCCD F1.0
 NMSD F1.0
 CREDU F4.0
 NuConDN F2.0
 TConDN F1.0
 EBPIN F1.0
 EBWW F1.0
 EBCOI F1.0
 EBTBC F1.0
 EBCOP F1.0
 EBPRV F1.0
 EBVAL F1.0
 Alumbra F1.0
 Agua F1.0
 Excre F1.0
 Pared F1.0
 Piso F1.0
 SalRx F1.0
 AgRT F1.0
 AgBac F1.0
 LetOK F1.0
 TCoc F1.0
 VivOK F1.0
 NBI F1.0
 SexoJF F1.0
 EdadJF F2.0
 ActivJF F2.0
 EduNivJF F1.0
 EduAJF F2.0
 NBPIN F1.0
 NBWW F1.0
 NBCOI F1.0
 NBTBC F1.0
 NBCOP F1.0
 NBPRV F1.0
 NBVAL F1.0
 NBAA F1.0
 NJtos F1.0
 NPapB F1.0
 CUI F1.0
 SIS F1.0
 Seguro F1.0
 EdadM F5.2
 NMEF F1.0
 SEdMEF F2.0
 FNac DATETIME23.2
 FEnc DATETIME23.2
 FALT F4.0
 FLAT F14.10
 FLON F14.10
 VertOc F14.10
 P1R F20.10
 P2R F20.10
 SWt F10.2
 P3HB F10.2
 P3CO F10.2
 ccdd A2
 ccpp A2
 ccdi A2
 CampoD F2.0
 QUINTF F10.2
 CodETZ F10.2
 QMEF F2.0
 EtapaC F2.0
 INEIE8 F1.0
 Equipo F1.0
 Periodo F2.0
 Salida F2.0
 StatusM F1.0
 OrdVis F2.0
 NTotVis F2.0
 EvEpiWk F5.0
 .
* CACHE.
EXECUTE.
VARIABLE LEVEL
 P1R P2R SWt P3HB P3CO FLAT FLON FALT (SCALE)
 .
* DATASET NAME P WINDOW=FRONT.
RECODE PNACG ( LO THRU 499, 5001 THRU HI = SYSMIS ) .
RECODE EBPIN EBWW EBCOI EBTBC EBCOP EBPRV EBVAL ( 1 THRU HI = 1 ) .
RECODE 	Alumbra	Agua Excre Pared Piso SalRx ActivJF ( 0 = SYSMIS ) .
RECODE Seguro ( 7 = SYSMIS ) .
IF ( ( CREDU / 30.4375 ) > EdadM ) CREDU = -2 .
RECODE CREDU ( LO THRU -2, 2000 THRU HI = SYSMIS ) .
COMPUTE P1R = P1R * (1E-9) .
COMPUTE P2R = P2R * (1E-6) .
RECODE P2R ( 1 THRU HI = 1 ) .
COMPUTE SWt = 1.0 / ( P1R * P2R ) .
COMPUTE SWtH = 1.0 / ( P1R * P2R * P3HB ) .
COMPUTE SWtN = 1.0 / ( P1R * P2R * P3CO ) .
IF ( EdadM < 0 ) EdadM = -1 .
COMPUTE DPTOPS2 = 0 .
IF ( ccdd = '01' ) DPTOPS2 = 1 .
IF ( ccdd = '06' ) DPTOPS2 = 1 .
IF ( ccdd = '25' ) DPTOPS2 = 1 .
IF ( ccdd = '03' ) DPTOPS2 = 1 .
IF ( ccdd = '09' ) DPTOPS2 = 1 .
IF ( ccdd = '10' ) DPTOPS2 = 1 .
IF ( ccdd = '05' ) DPTOPS2 = 1 .
IF ( ccdd = '08' ) DPTOPS2 = 1 .
IF ( ccdd = '21' ) DPTOPS2 = 1 .
FORMAT P1R P2R P3HB P3CO ( F12.9 ) .
MISSING VALUES Sexo ( 0 ) EdadM ( -1 ) HbCORR ( -1 ) .
VARIABLE LABELS
	Amb	'Cdigo de mbito'
	Cong	'Cdigo de Conglomerado'
	Viv	'Cdigo de Vivienda'
	Hog	'Cdigo de Hogar'
	IdM	'Cdigo de Nio'
	Estrato	'Cdigo de Estrato'
	Cong1	'IGNORAR'
	Cong2	'IGNORAR'
	TResiM	'Tiempo de Residencia (m)'
	Sexo	'Sexo'
	Met	'Mtodo de Talla'
	PesoKg	'Peso neto (Kg)'
	TallaCm	'Talla (cm)'
	PNacG	'Peso al Nacer (g)'
	ZHAZ	'Puntaje Z TE 2006'
	ZWHZ	'Puntaje Z PT 2006'
	HFAZ	'Puntaje Z TE 1979'
	WFHZ	'Puntaje Z PT 1979'
	IMC	'ndice de Masa Corporal'
	HbCORR	'Hb g/d corregida'
	Retinol	'Retinol ug/dL'
	MaOK	'Madre con Criterios Ok'
	MaPte	'Madre presente (1 si)'
	MaEdA	'Edad de la Madre (a)'
	MaEdu	'Educacin de Madre'
	HV109	'Educacin de Madre (ENDES 2000)'
	ConLM	'Lactancia Materna Ahora'
	ConAL	'Alimentos No LM Ahora'
	AliOK	'Esquema Alimentacin Ok'
	VComio	'Comidas Semislidas (veces/d)'
	MasGra	'Grasa Adicional'
	VitA	'Vitamina A'
	VFe	'Suplemento de Hierro (veces/sem)'
	SupOK	'Esquema Suplementos Ok'
	PrAOK	'Protena Animal (veces/d)'
	PDia2w	'EDA quincena'
	PTos2w	'IRA quincena'
	PFie2w	'Fiebre quincena'
	NED7	'Dias EDA'
	NER7	'Dias IRA'
	NEDY	'EDA ayer'
	NERY	'IRA ayer'
	DenomP	'Dias observados retro'
	DenomID	'Dias s/EDA'
	DenomIR	'Dias s/IRA'
	DenomRD	'Dias c/EDA'
	DenomRR	'Dias c/IRA'
	NumeID	'Inicios EDA'
	NumeIR	'Inicios IRA'
	NumeRD	'Fines EDA'
	NumeRR	'Fines IRA'
	NVBCG	'Dosis BCG'
	NVPOL	'Dosis Polio'
	NVDPT	'Dosis DPT'
	NVHEP	'Dosis Hepatitis'
	NVHIB	'Dosis Haemophilus'
	NVSAR	'Dosis Sarampin'
	NVPaR	'Dosis Pap+Rub'
	NVAMA	'Dosis F. Amarilla'
	NVVTA	'Dosis Vit A'
	NCCD0	'CRED primer ao'
	ECCD0	'IGNORAR'
	NMCCD	'Mensajes en CRED'
	NMSD	'SD 1:<6m'
	CREDU	'Edad (d) ultimo CRED'
	NuConDN	'IGNORAR'
	TConDN	'IGNORAR'
	EBPIN	'Beneficiario PIN'
	EBWW	'Beneficiario WW'
	EBCOI	'Beneficiario ComInf'
	EBTBC	'Beneficiario PANTBC'
	EBCOP	'Beneficiario ComPop'
	EBPRV	'Beneficiario Privados'
	EBVAL	'Beneficiario VL'
	Alumbra	'Alumbrado'
	Agua	'Agua'
	Excre	'Excretas'
	Pared	'Pared'
	Piso	'Piso'
	SalRx	'Sal (test)'
	AgRT	'Cloracin del Agua'
	AgBac	'Bacteriologa del Agua'
	LetOK	'Letrina (1 ok)'
	TCoc	'Tipo de Cocina 1 G/E'
	VivOK	'Vivienda (1 ok)'
	NBI	'Necesidades Bsicas Insatisfechas'
	SexoJF	'Sexo del Jefe de Familia'
	EdadJF	'Edad (a) del Jefe de Familia'
	ActivJF	'Actividad del Jefe de Familia'
	EduNivJF	'Nivel Educativo del Jefe de Familia'
	EduAJF	'Aos de Estudios del Jefe de Familia'
	NBPIN	'Familiares en PIN'
	NBWW	'Familiares en WW'
	NBCOI	'Familiares en ComInf'
	NBTBC	'Familiares en PANTBC'
	NBCOP	'Familiares en ComPop'
	NBPRV	'Familiares en Privados'
	NBVAL	'Familiares en VL'
	NBAA	'Familiares en AA'
	NJtos	'Familiares en Juntos'
	NPapB	'Familiares con Papilla'
	CUI	'CUI'
	SIS	'SIS'
	Seguro	'Seguro de Salud'
	EdadM	'Edad en meses'
	NMEF	'IGNORAR'
	SEdMEF	'IGNORAR'
	FNac	'Fecha de nacimiento'
	FEnc	'Fecha de la encuesta'
	FALT	'Altitud (m)'
	FLAT	'Latitud WGS84'
	FLON	'Longitud WGS84'
	VertOc	'Vertiente'
	P1R	'P1 (conglomerado)'
	P2R	'P2 (Vivienda)'
	SWt	'Ponderacin'
	P3HB	'P3 (Hemoglobina)'
	P3CO	'P3 (Consumo)'
	ccdd	'UBIGEO Regin'
	ccpp	'UBIGEO Provincia'
	ccdi	'UBIGEO Distrito'
	CampoD	'IGNORAR'
	QUINTF	'Quintil FonCoDes 2005'
	CodETZ	'Cdigo Zonal PRONAA'
	QMEF	'Quintil MEF 2001'
	EtapaC	'Etapa Crecer'
	INEIE8	'Estrato Demogrfico'
	Equipo	'Equipo'
	Periodo	'Periodo'
	Salida	'Salida'
	StatusM	'Situacin del Conglomerado'
	OrdVis	'IGNORAR'
	NTotVis	'IGNORAR'
	EvEpiWk	'Semana Epidemiolgica'
	SWtH	'Ponderacin (Hb)'
	SWtN	'Ponderacin (Consumo)'
	DPTOPS2 'Regin PARSALUD II' 
.
VALUE LABELS
	/ Periodo
		1 '2008-I'
		2 '2008-III'
		3 '2008-IV'
		4 '2009-II'
		5 '2009-III'
		6 '2009-IV'
		7 '2010-I'
	/ StatusM
		11 'terminados'
		12 'pendientes'
		13 'salen por reemplazo'
		14 'entran por reemplazo'
		15 'perdidos'
		16 'sorteo no documentado'
		17 'no intentaron, por referencia'
		18 'marco local incompleto'
		19 'solo cp mapeados'
		20 'excluido, dificultad logstica'
		21 'rea no corresponde'
		22 'tiempo no corresponde'
		23 'cobertura incompleta'
		29 'fuera de muestra'
		31 'faltan documentos'
		80 'no usado'
		99 'prueba/piloto/descarte'
	/ VertOc
		1 'Pacfico'
		2 'Atlntico'
	/ Estrato
		1 'Lima Metropolitana'
		2 'Resto de Costa'
		3 'Sierra Urbana'
		4 'Sierra Rural'
		5 'Selva'
	/ INEIE8
		1 '>100k viviendas'
		2 '>20k a 100k viviendas'
		3 '>10k a 20k viviendas'
		4 '>4k a 10k viviendas'
		5 '401 a 4000 viviendas'
		6 '100-401 viviendas'
		7 'AER compuesta (dispersa)'
		8 'AER simple'
	/ EtapaC
		0 'No'
		1 'C1'
		2 'C2'
		3 'C3'
		4 'C4'
	/ QMEF QUINTF
		1 'Q1'
		2 'Q2'
		3 'Q3'
		4 'Q4'
		5 'Q5'
	/ Alumbra
		1 'electricidad'
		2 'kerosene'
		3 'vela'
		4 'otro'
		5 'ninguno'
	/ Agua
		1 'red pblica dentro'
		2 'red pblica fuera'
		3 'piln/grifo pblico'
		4 'pozo'
		5 'rio/acequia/manantial'
		6 'camin/tanque/aguatero'
		7 'otro'
	/ Excre
		1 'red pblica dentro'
		2 'red pblica fuera'
		3 'letrina (tcnica)'
		4 'pozo ciego/negro/silo'
		5 'rio/acequia/canal'
		6 'otro'
	/ Pared
		1 'ladrillo/cemento'
		2 'adobe/tapia'
		3 'quincha (caa+barro)'
		4 'piedra con barro'
		5 'madera'
		6 'estera'
		7 'otro'
		8 'ninguno'
	/ Piso
		1 'parquet/madera pulida'
		2 'lminas asflticas/vinlicos'
		3 'losetas/terrazos'
		4 'madera (entablados)'
		5 'cemento/falso piso'
		6 'tierra/arena/ripio'
		7 'otro'
	/ SalRx
		1 '0-6 ppm'
		2 '7-14 ppm'
		3 '15-29 ppm'
		4 '30+ ppm'
	/ AgRT
		0 'cloro- s/tratar'
		1 'cloro- tratada'
		2 'cloro+ s/tratar'
		3 'cloro+ tratada'
	/ AgBac
		0 'no coliformes'
		1 'E coli o coliformes'
	/ TCoc
		1 'gas/elctrica'
		2 'lea o carbn mejorada'
		3 'otro'
	/ Sexo SexoJF
		1 'm'
		2 'f'
	/ ActivJF
		1 'Trabajador dependiente asalariado'
		2 'Trabajador independiente'
		3 'Empleador'
		4 'Servicio domstico'
		5 'Buscando trabajo'
		6 'Quehaceres del hogar'
		7 'Estudiante'
		8 'Jubilado'
		9 'Trabajador familiar no remunerado'
		10 'Sin actividad'
	/ Met
		1 'decbito'
		2 'de pie'
	/ MaEdu EduNivJF
		0 'no lee ni escribe'
		1 'solo lee'
		2 'lee y escribe'
		3 'preescolar'
		4 'primaria'
		5 'secundaria'
		6 'sup. tcnico'
		7 'sup. universitario'
	/ HV109
		0 '0'
		1 '1'
		2 '2'
		3 '3'
		4 '4'
		5 '5'
		6 '6'
		7 '7'
		8 '8'
	/ PTos2w
		1 'tos P333'
		2 'tos P334A'
		3 'no tos'
	/ NMSD
		1 'hace <6m'
		2 'hace 6+ m'
		3 'nunca'
	/ SIS
		1 'si, muestra id'
		2 'si, no muestra id'
		3 'no'
	/ Seguro
		1 'EsSalud'
		2 'FFAA' 
		3 'SIS'
		4 'EPS'
		5 'Privado'
		6 'No tiene'
	/ MaOK ConLM ConAL AliOK SupOK PDia2w PFie2w LetOk VivOk CUI
		1 'si'
		2 'no'
	/ MaPte MasGra VitA NEDY NERY EBPIN EBWW EBCOI EBTBC EBCOP EBPRV EBVAL
		1 'si'
		0 'no'
	/ DPTOPS2 0 'no' 1 'si'
.
SORT CASES BY amb cong viv hog idm .
MATCH FILES
	/FILE *
	/TABLE NBSAV /RENAME (PESO PESOF = d0 d1)
	/BY amb cong viv hog idm /MAP
	/DROP= d0 d1 .
SORT CASES BY amb cong viv hog idm .
SORT CASES BY amb cong .
MATCH FILES
	/FILE *
	/TABLE TBSAV
	/RENAME
		(AER CampoD CCCP CCDD CCDI CCPP CodETZ DM2E DPTOPS2 Equipo Estrato
		EtapaC FALT FFinCong FIni FIniCong FLAT FLON INEIE8 MONIN5 N04CO N04HA N04HB
		NClasV NCoEViv NEleDes NEleNo NEleNo3v NEleRe NGes NHabs NMEF NNi02 NNi04
		NNoEle NomCP NomDD NomDI NomPR NuHog NVisInf NVivs NVivsL NVivsLE P1C P1M
		P1N P1R P2F P2R Periodo PlaImp QMEF QUINTF RegNat Salida StatusM SWt SWtC
		TotVivA TotVivE TotVivO TotVivR VertOc VFinCong Viv0 = d0 d1 d2 d3 d4 d5 d6
		d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26
		d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45
		d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65)
	/BY amb cong /MAP
	/DROP= d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19
		d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38
		d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57
		d58 d59 d60 d61 d62 d63 d64 d65 .
SORT CASES BY amb cong viv hog idm .
SAVE /OUTFILE PBSAV /COMPRESSED .
* Tabla de Mujeres .
* GET TRANSLATE FILE=MBDBF /TYPE=DBF /MAP .
GET DATA  /TYPE = TXT /FILE = MBCSV
 /DELCASE = LINE /DELIMITERS = "," /QUALIFIER = '"'
 /ARRANGEMENT = DELIMITED /FIRSTCASE = 2 /IMPORTCASE = ALL
 /VARIABLES =
 Amb A3
 Cong A4
 Viv A4
 Hog A1
 IdM A2
 Edad F2.0
 Estrato F1.0
 Cong1 F6.2
 Cong2 F7.2
 EFisM F1.0
 EGesW F2.0
 PesoKgSR F5.2
 TallaCm F5.1
 IMC F5.2
 FEnc DATETIME23.2
 FALT A8
 FLAT F2.0
 FLON F14.10
 VertOc F14.10
 HbCORR F1.0
 Retinol F5.2
 Yoduria F5.2
 FeFo F6.2
 VitA F1.0
 Multi F1.0
 Otros F1.0
 EBPIN F1.0
 EBWW F1.0
 EBCOI F1.0
 EBTBC F1.0
 EBCOP F1.0
 EBPRV F1.0
 EBVAL F1.0
 NBI F1.0
 P1R F20.10
 P2R F20.10
 SWt F10.2
 ccdd A2
 ccpp A2
 ccdi A2
 CampoD F2.0
 QMEF F10.2
 CodETZ F1.0
 EtapaC F2.0
 INEIE8 F1.0
 Equipo F1.0
 Periodo F2.0
 Salida F1.0
 StatusM F2.0
 .
* CACHE.
EXECUTE.
* DATASET NAME M WINDOW=FRONT.
RECODE EFisM ( 0, 5 THRU HI = SYSMIS ) .
RECODE EBPIN EBWW EBCOI EBTBC EBCOP EBPRV EBVAL ( 1 THRU HI = 1 ) .
COMPUTE P1R = P1R * (1E-9) .
COMPUTE P2R = P2R * (1E-6) .
RECODE P2R ( 1 THRU HI = 1 ) .
* COMPUTE SWt = 1.0 / ( P1R * P2R ) .
COMPUTE DPTOPS2 = 0 .
IF ( ccdd = '01' ) DPTOPS2 = 1 .
IF ( ccdd = '06' ) DPTOPS2 = 1 .
IF ( ccdd = '25' ) DPTOPS2 = 1 .
IF ( ccdd = '03' ) DPTOPS2 = 1 .
IF ( ccdd = '09' ) DPTOPS2 = 1 .
IF ( ccdd = '10' ) DPTOPS2 = 1 .
IF ( ccdd = '05' ) DPTOPS2 = 1 .
IF ( ccdd = '08' ) DPTOPS2 = 1 .
IF ( ccdd = '21' ) DPTOPS2 = 1 .
MISSING VALUES HbCORR ( -1 ) .
FORMAT P1R P2R ( F12.9 ) .
VARIABLE LABELS
	Amb	'Cdigo de mbito'
	Cong	'Cdigo de Conglomerado'
	Viv	'Cdigo de Vivienda'
	Hog	'Cdigo de Hogar'
	IdM	'Cdigo de Persona'
	Edad	'Edad (aos)'
	Estrato	'Cdigo de Estrato'
	Cong1	'IGNORAR'
	Cong2	'IGNORAR'
	EFisM	'Estado Fisiolgico (Pregunta 504)'
	PesoKgSR	'Peso en Kg (s/ropa)'
	EGesW	'Edad Gestacional (sem)'
	TallaCm	'Talla en cm'
	IMC	'ndice de Masa Corporal'
	FEnc	'Fecha de la encuesta'
	FALT	'Altitud (m)'
	FLAT	'Latitud WGS84'
	FLON	'Longitud WGS84'
	VertOc	'Vertiente'
	HbCORR	'Hemoglobina, corregida por altitud'
	Retinol	'Retinol srico'
	Yoduria	'Yoduria'
	FeFo	'Sup. Hierro y Ac.Flico'
	VitA	'Sup. Vitamina A'
	Multi	'Sup. Multivitamnico'
	Otros	'Otros Sup.'
	EBPIN	'Beneficiario PIN'
	EBWW	'Beneficiario WW'
	EBCOI	'Beneficiario ComInf'
	EBTBC	'Beneficiario PANTBC'
	EBCOP	'Beneficiario ComPop'
	EBPRV	'Beneficiario Privados'
	EBVAL	'Beneficiario VL'
	NBI	'Necesidades Bsicas Insatisfechas en el Hogar'
	P1R	'P1 (conglomerado)'
	P2R	'P2 (Vivienda)'
	SWt	'Ponderacin'
	ccdd	'UBIGEO Regin'
	ccpp	'UBIGEO Provincia'
	ccdi	'UBIGEO Distrito'
	CampoD	'IGNORAR'
	QMEF	'Quintil MEF'
	CodETZ	'Cdigo Zonal PRONAA'
	EtapaC	'Etapa Crecer'
	INEIE8	'Estrato Demogrfico'
	Equipo	'Equipo'
	Periodo	'Perodo MONIN'
	Salida	'Salida'
	StatusM	'Situacin del Conglomerado'
	DPTOPS2 'Regin PARSALUD II'
.
VALUE LABELS
	/ Periodo
		1 '2008-I'
		2 '2008-III'
		3 '2008-IV'
		4 '2009-II'
		5 '2009-III'
		6 '2009-IV'
		7 '2010-I'
	/ StatusM
		11 'terminados'
		12 'pendientes'
		13 'salen por reemplazo'
		14 'entran por reemplazo'
		15 'perdidos'
		16 'sorteo no documentado'
		17 'no intentaron, por referencia'
		18 'marco local incompleto'
		19 'solo cp mapeados'
		20 'excluido, dificultad logstica'
		21 'rea no corresponde'
		22 'tiempo no corresponde'
		23 'cobertura incompleta'
		29 'fuera de muestra'
		31 'faltan documentos'
		80 'no usado'
		99 'prueba/piloto/descarte'
	/ Estrato
		1 'Lima Metropolitana'
		2 'Resto de Costa'
		3 'Sierra Urbana'
		4 'Sierra Rural'
		5 'Selva'
	/ INEIE8
		1 '>100k viviendas'
		2 '>20k a 100k viviendas'
		3 '>10k a 20k viviendas'
		4 '>4k a 10k viviendas'
		5 '401 a 4000 viviendas'
		6 '100-401 viviendas'
		7 'AER compuesta (dispersa)'
		8 'AER simple'
	/ EtapaC
		0 'No'
		1 'C1'
		2 'C2'
		3 'C3'
		4 'C4'
	/ QMEF
		1 'Q1'
		2 'Q2'
		3 'Q3'
		4 'Q4'
		5 'Q5'
	/ EFisM
		1 'gestante'
		2 'lactante'
		3 'ninguna'
		4 'ambas'
	/ FeFo
		0 'no'
		1 'hierro'
		2 'ac. flico'
		3 'hierro y flico'
	/ VitA Multi Otros
		1 'si'
		2 'no'
	/ EBPIN EBWW EBCOI EBTBC EBCOP EBPRV EBVAL
		1 'si'
		0 'no'
	/ DPTOPS2 0 'no' 1 'si'
.
SORT CASES BY amb cong .
MATCH FILES
	/FILE *
	/TABLE TBSAV
	/RENAME
		(AER CampoD CCCP CCDD CCDI CCPP CodETZ DM2E DPTOPS2 Equipo Estrato
		EtapaC FALT FFinCong FIni FIniCong FLAT FLON INEIE8 MONIN5 N04CO N04HA N04HB
		NClasV NCoEViv NEleDes NEleNo NEleNo3v NEleRe NGes NHabs NMEF NNi02 NNi04
		NNoEle NomCP NomDD NomDI NomPR NuHog NVisInf NVivs NVivsL NVivsLE P1C P1M
		P1N P1R P2F P2R Periodo PlaImp QMEF QUINTF RegNat Salida StatusM SWt SWtC
		TotVivA TotVivE TotVivO TotVivR VertOc VFinCong Viv0 = d0 d1 d2 d3 d4 d5 d6
		d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26
		d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45
		d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65)
	/BY amb cong /MAP
	/DROP= d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19
		d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38
		d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57
		d58 d59 d60 d61 d62 d63 d64 d65 .
SORT CASES BY amb cong viv hog idm .
SAVE /OUTFILE MBSAV /COMPRESSED .
* /DROP D_R .
* Resumen .
GET /FILE TBSAV .
DESCRIPTIVES ALL .
DISPLAY DICTIONARY .
GET /FILE PBSAV .
DESCRIPTIVES ALL .
DISPLAY DICTIONARY .
GET /FILE MBSAV .
DESCRIPTIVES ALL .
DISPLAY DICTIONARY .
* Planes muestrales .
GET /FILE PBSAV .
SELECT IF ( P1R > 0 AND P2R > 0 ) .
CSPLAN ANALYSIS /PLAN FILE='X:\P.xml' /PLANVARS ANALYSISWEIGHT=swt /PRINT PLAN 
 /DESIGN STAGELABEL='Conglomerado' STRATA= periodo estrato CLUSTER= cong /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p1r
 /DESIGN STAGELABEL='Hogar' CLUSTER= amb viv hog /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p2r
 .
GET /FILE PBSAV .
SELECT IF ( P1R > 0 AND P2R > 0 AND P3HB > 0 ) .
CSPLAN ANALYSIS /PLAN FILE='X:\H.xml' /PLANVARS ANALYSISWEIGHT=swth /PRINT PLAN 
 /DESIGN STAGELABEL='Conglomerado' STRATA= periodo estrato CLUSTER= cong /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p1r
 /DESIGN STAGELABEL='Hogar' CLUSTER= amb viv hog /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p2r
 /DESIGN STAGELABEL='Nio' CLUSTER= idm /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p3hb
 .
GET /FILE PBSAV .
SELECT IF ( P1R > 0 AND P2R > 0 AND P3CO > 0 ) .
CSPLAN ANALYSIS /PLAN FILE='X:\N.xml' /PLANVARS ANALYSISWEIGHT=swtn /PRINT PLAN 
 /DESIGN STAGELABEL='Conglomerado' STRATA= periodo estrato CLUSTER= cong /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p1r
 /DESIGN STAGELABEL='Hogar' CLUSTER= amb viv hog /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p2r
 /DESIGN STAGELABEL='Nio' CLUSTER= idm /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p3co
 .
GET /FILE MBSAV .
SELECT IF ( P1R > 0 AND P2R > 0 ) .
CSPLAN ANALYSIS /PLAN FILE='X:\M.xml' /PLANVARS ANALYSISWEIGHT=swt /PRINT PLAN 
 /DESIGN STAGELABEL='Conglomerado' STRATA= periodo estrato CLUSTER= cong /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p1r
 /DESIGN STAGELABEL='Hogar' CLUSTER= amb viv hog /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p2r
 .
GET /FILE TBSAV .
SELECT IF ( P1R > 0 ) .
CSPLAN ANALYSIS /PLAN FILE='X:\C.xml' /PLANVARS ANALYSISWEIGHT=swtc /PRINT PLAN 
 /DESIGN STAGELABEL='Conglomerado' STRATA= periodo estrato CLUSTER= cong /ESTIMATOR TYPE=EQUAL_WOR /INCLPROB VARIABLE= p1r
 .

